/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

// I also parameterised the loop counts for flexibility and rearranged
// things for efficiency. Though it looks different it is still almost
// the same shader as the original I took from GlsSandbox.com, TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////
#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;

void main( void ) {
	vec3 light_color = vec3(1.2,0.8,0.6);
	
	float t = time*20.0;
	vec2 position = ( scaled_gl_FragCoord.xy -  resolution.xy*.5 ) / resolution.x;

	// 256 angle steps
	float angle = atan(position.y,position.x)/(2.*3.14159265359);
	angle -= floor(angle);
	float rad = length(position);
	
	float color = 0.0;
	float brightness = 0.015;
	float speed = 0.3;
	
	for (int i = 0; i < 2; i++) {
		float angleRnd = floor(angle*14.)+1.;
		float angleRnd1 = fract(angleRnd*fract(angleRnd*.7235)*45.1);
		float angleRnd2 = fract(angleRnd*fract(angleRnd*.82657)*13.724);
		float t = t*speed + angleRnd1*10.;
		float radDist = sqrt(angleRnd2+float(i));
		
		float adist = radDist/rad*.1;
		float dist = (t*.1+adist);
		dist = abs(fract(dist)-.5);
		color +=  (1.0 / (dist))*cos(0.7*(sin(t)))*adist/radDist * brightness;
		angle = fract(angle+.61);
	}
	
	
	gl_FragColor = vec4(color,color,color,1.0)*vec4(light_color,1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}